/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.browser;

import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.BrowserFolder;
import ibm.nways.jdm.browser.BrowserNode;
import ibm.nways.jdm.browser.BrowserQuery;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import java.io.BufferedInputStream;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;

public class Browser
implements NavigationBrowserEventListener {
    private static final int COLON = 58;
    private static final int PERIOD = 46;
    private static final int EOLN = 10;
    private static final int COMMA = 44;
    private static final int QUOTE = 34;
    protected BrowserNode myNode;
    protected boolean expanded = false;
    protected SnmpContextModel model;
    protected BufferedInputStream input;
    protected int ix;
    protected int numrecords;
    protected boolean eofRead;
    protected boolean eofReached;
    protected byte[] buffer;
    protected BrowserFolder rootFolder;
    protected MyFolder topFolder;
    protected String browserTitle;
    protected BrowserQuery service;

    public Browser(String string, URL uRL, SnmpContextModel snmpContextModel) {
        System.out.println("Warning: Browser should not be started with input URL");
    }

    public Browser(String string, JdmBrowser jdmBrowser, SnmpContextModel snmpContextModel) {
        if (string == null) {
            System.err.println("Error: null title passed to Browser");
        }
        if (jdmBrowser == null) {
            System.err.println("Error: null applet passed to Browser");
        }
        if (snmpContextModel == null) {
            System.err.println("Error: null model passed to Browser");
        }
        try {
            this.service = (BrowserQuery)Naming.lookup("//" + jdmBrowser.getCodeBase().getHost() + ":" + jdmBrowser.getServerPortNumber() + "/BrowserService");
        }
        catch (NotBoundException notBoundException) {
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.topFolder = new MyFolder(string, this.service, snmpContextModel, jdmBrowser);
        this.topFolder.setIsInitiallyExpanded(false);
    }

    public Browser(JdmBrowser jdmBrowser, SnmpContextModel snmpContextModel) {
        this(Browser.getTitle(), jdmBrowser, snmpContextModel);
    }

    protected static String getTitle() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm.browser.BrowserPanelResources");
            return resourceBundle.getString("browserTitle");
        }
        catch (Exception exception) {
            System.err.println("Unable to access translation resources for Mib browser");
            return "MIB Browser";
        }
    }

    public NavigationFolder getRootFolder() {
        return this.topFolder;
    }

    public void navPointSelected(NavigationPoint navigationPoint) {
    }

    public void navPointDeselected() {
    }

    public void navigationFolderCollapsed(NavigationFolder navigationFolder) {
    }

    public void navigationFolderExpanded(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2;
        if (navigationFolder instanceof BrowserFolder) {
            navigationFolder2 = (BrowserFolder)navigationFolder;
            ((BrowserFolder)navigationFolder2).expand();
        }
        if (navigationFolder instanceof MyFolder) {
            navigationFolder2 = (MyFolder)navigationFolder;
            ((MyFolder)navigationFolder2).expand();
        }
    }

    protected class MyFolder
    extends NavigationFolder {
        protected String title;
        protected boolean expanded = false;
        protected SnmpContextModel model;
        protected BrowserQuery service;
        protected JdmBrowser appl;
        private ResourceBundle myResources;

        public MyFolder(String string, BrowserQuery browserQuery, SnmpContextModel snmpContextModel, JdmBrowser jdmBrowser) {
            super(string, new NavigationDestination("ibm.nways.jdm.NilDestination", null), "MIB Browser");
            Browser.this = Browser.this;
            this.title = string;
            this.model = snmpContextModel;
            this.service = browserQuery;
            this.appl = jdmBrowser;
        }

        public String getTitle() {
            return this.title;
        }

        public void expand() {
            if (!this.expanded) {
                if (this.service == null) {
                    try {
                        this.service = (BrowserQuery)Naming.lookup("//" + this.appl.getCodeBase().getHost() + ":" + this.appl.getServerPortNumber() + "/BrowserService");
                    }
                    catch (NotBoundException notBoundException) {
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                }
                if (this.service != null) {
                    try {
                        BrowserNode browserNode = this.service.getNode("1");
                        Browser.this.rootFolder = new BrowserFolder(browserNode, this.service, this.model, this.appl);
                        Browser.this.topFolder.add(Browser.this.rootFolder);
                        Browser.this.rootFolder.expand();
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (RemoteException remoteException) {
                        System.out.println(remoteException);
                        remoteException.printStackTrace();
                    }
                    this.expanded = true;
                    return;
                }
                this.displayMsg(this.getNLSString("noService"));
            }
        }

        protected void displayMsg(String string) {
            if (this.appl != null) {
                this.appl.displayMsg(string);
                return;
            }
            System.out.println("Null appl in BrowserFolder");
        }

        private String getNLSString(String string) {
            try {
                if (this.myResources == null) {
                    this.myResources = ResourceBundle.getBundle("ibm.nways.jdm.browser.BrowserPanelResources", Locale.getDefault());
                }
                return this.myResources.getString(string);
            }
            catch (Exception exception) {
                return string;
            }
        }
    }
}

